<?php

namespace Velis\Debugger\Renderer;

use Throwable;
use Velis\Dto\BaseDto;

/**
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
class ArrayRenderer implements RendererInterface
{
    /**
     * @param BaseDto[] $modulesOutput
     */
    public function get(Throwable $throwable, array $modulesOutput = []): array
    {
        $result = [];

        foreach ($modulesOutput as $moduleName => $moduleResult) {
            $result[$moduleName] = $moduleResult->toArray();
        }

        return $result;
    }
}
