<?php

namespace Velis\Debugger\Module;

use Throwable;
use Velis\Debugger\Debugger;
use Velis\Dto\BaseDto;

/**
 * When need to access any additional information from the exception, create a new module and append it to the debugger.
 * @see Debugger::$modules
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
abstract class AbstractDebuggerModule
{
    protected bool $isInitialized = false;

    public function __construct(protected Throwable $exception)
    {
    }

    abstract public static function getModuleName(): string;
    public function isInitialized(): bool
    {
        return $this->isInitialized;
    }

    abstract public function getResult(): BaseDto;
    abstract public function handle();
}
