<?php

namespace Velis\Debugger;

use Phalcon\Di\DiInterface;
use Phalcon\Di\ServiceProviderInterface;
use Velis\App;
use Velis\Log\LoggerInterface;

class DebuggerServiceProvider implements ServiceProviderInterface
{
    public function register(DiInterface $di): void
    {
        $di->set(ErrorMailFactory::class, function () {
            return new ErrorMailFactory(App::$user, App::$session, App::$config);
        });

        $di->set(ErrorReporter::class, function () use ($di) {
            $mailFactory = $di->get(ErrorMailFactory::class);
            $db = App::$di['db'];
            $dbExceptionLogger = App::getService('logger.dbException');
            $logger = App::getService(LoggerInterface::class);

            return new ErrorReporter(
                $mailFactory,
                $db,
                $dbExceptionLogger,
                $logger,
            );
        });
    }
}
