<?php

namespace Velis\Db\QueryBuilder;

use Velis\Db\QueryBuilder\Enums\JoinExpressionType;

/**
 * @author Jakub Szczugieł <jakub.szczugiel@velistech.com>
 */
class JoinExpression
{
    public function __construct(
        private readonly string $table,
        private readonly string $first,
        private readonly ?string $operator = null,
        private readonly ?string $second = null,
        private readonly JoinExpressionType $type = JoinExpressionType::INNER,
        private readonly bool $where = false
    ) {
    }

    public function getExpression(): string
    {
        if (!$this->operator) {
            return "{$this->type->value} JOIN {$this->table} USING ({$this->first})";
        }

        if (!$this->second) {
            return "{$this->type->value} JOIN {$this->table} ON {$this->first} = {$this->operator}";
        }

        return "{$this->type->value} JOIN {$this->table} ON {$this->first} {$this->operator} {$this->second}";
    }
}
