<?php

namespace Velis\Db;

class PgSnowflakeMock extends Postgres
{
    /**
     * {@inheritDoc}
     */
    public function getColumns(string $dataSource): array
    {
        return parent::getColumns(strtolower($dataSource));
    }

    /**
     * {@inheritDoc}
     */
    protected function filterRow(array $row): array
    {
        foreach ($row as $key => $value) {
            $newKey = strtoupper($key);
            unset($row[$key]);
            $row[$newKey] = $value;
        }

        return $row;
    }
}
