<?php

namespace Velis\Db;

/**
 * Implement a database expression
 */
interface ExpressionInterface
{
    /**
     * Set a field name.
     *
     * @return void
     */
    public function setFieldName(string $fieldName);
    /**
     * Insert required parameters to the $params
     * in order to create an expression
     *
     * @param $params A reference to $_listParams in the DataObject
     * @return void
     */
    public function bindParams(&$params);
    /**
     * Get SQL expression
     */
    public function getSql(): string;
}
