<?php

namespace Velis;

class CronParameter
{
    private string $name;
    private bool $required;
    private string $type;
    private array $options;

    public function __construct(string $name, bool $required, string $type, array $options = [])
    {
        $this->name = $name;
        $this->required = $required;
        $this->type = $type;
        $this->options = $options;
    }

    /**
     * Is parameter required
     * @return bool
     */
    public function isRequired(): bool
    {
        return $this->required;
    }

    /**
     * Get parameter name
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * Get parameter options
     * @return array
     */
    public function getOptions(): array
    {
        return $this->options;
    }

    /**
     * Get parameter options
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }
}