<?php

namespace Velis\Cache;

use Exception;
use Psr\Cache\CacheItemInterface;
use Psr\Cache\CacheItemPoolInterface;
use Psr\SimpleCache\InvalidArgumentException;
use Velis\App;

/**
 * PSR-6 cache pool implementation
 * @author Paweł Szołucha <pawel.szolucha@velis.pl>
 */
class ItemPool implements CacheItemPoolInterface
{
    /**
     * Returns a cache Item representing the specified key.
     *
     * @param string $key
     * @return CacheItemInterface
     * @throws InvalidArgumentException
     */
    public function getItem($key)
    {
        if (App::$cache->has($key)) {
            return new Item($key, App::$cache->get($key));
        } else {
            return new Item($key);
        }
    }

    /**
     * Returns a traversable set of cache items.
     *
     * @param string[] $keys
     * @return array|\Traversable
     */
    public function getItems(array $keys = array())
    {
    }

    /**
     * Confirms if the cache contains specified cache item.
     *
     * @param string $key
     * @return bool
     */
    public function hasItem($key)
    {
    }

    /**
     * Deletes all items in the pool.
     *
     * @return bool
     */
    public function clear()
    {
    }

    /**
     * Removes the item from the pool.
     *
     * @param string $key
     * @return bool
     */
    public function deleteItem($key)
    {
    }

    /**
     * Removes multiple items from the pool.
     *
     * @param string[] $keys
     * @return bool
     */
    public function deleteItems(array $keys)
    {
    }

    /**
     * Persists a cache item immediately.
     *
     * Important: full namespace in argument hint is required due to IonCube issues
     *
     * @param CacheItemInterface $item
     * @return bool
     * @throws InvalidArgumentException
     */
    public function save(CacheItemInterface $item)
    {
        if ($item instanceof Item) {
            try {
                if (!App::$cache->set($item->getKey(), $item->get(), $item->getExpiration())) {
                    return false;
                }
            } catch (Exception $e) {
                return false;
            }
        } else {
            return false;
        }

        return true;
    }

    /**
     * Sets a cache item to be persisted later.
     *
     * Important: full namespace in argument hint is required due to IonCube issues
     *
     * @param CacheItemInterface $item
     * @return bool
     */
    public function saveDeferred(CacheItemInterface $item)
    {
    }

    /**
     * Persists any deferred cache items.
     *
     * @return bool
     */
    public function commit()
    {
    }
}
