<?php

namespace Velis\Cache;

/**
 * Interface for cache factories
 *
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
interface CacheFactoryInterface
{
    /**
     * Create file based cache
     *
     * @param array $options
     * @return CacheInterface
     */
    public function createFileCache(array $options): CacheInterface;

    /**
     * Create Redis cache
     *
     * @param array $options
     * @return CacheInterface
     */
    public function createRedisCache(array $options): CacheInterface;
}
