<?php

namespace Velis\Bpm\Workflow;

use Velis\Model\DataObject;
use Velis\Model\Sanitizable;

/**
 * Workflow log model
 * @author Olek Procki <olo@velis.pl>
 */
class Log extends DataObject implements Sanitizable
{

    const SUCCESS = 'Success';
    const NOTICE  = 'Notice';
    const ERROR   = 'Error';


    protected static $_logAvailable;


    /**
     * Returns log table name
     * @return string
     */
    protected function _getTableName()
    {
        return 'app.workflow_log_tab';
    }


    /**
     * Returns true if execution log is available
     * @return bool
     */
    public static function isLogAvailable()
    {
        if (!isset(self::$_logAvailable)) {
            $instance = new static();

            self::$_logAvailable = self::$_db->tableExists(
                $instance->_getTableName()
            );
        }
        return self::$_logAvailable;
    }
}
