<?php

namespace Velis\Bpm\Workflow\Handler;

use Velis\Bpm\Workflow\Handler;
use Velis\Bpm\Workflow;
use Exception;

/**
 * Stops source MVC Event
 * @author Olek Procki <olo@velis.pl>
 */
class Stop extends Handler
{

    /**
     * Handler execution method
     *
     * @param \Velis\Bpm\Workflow\Subject $subject
     * @param mixed $additionalData
     */
    public function run($subject, $additionalData)
    {
        $invokedEvent = $this->_workflow->getInvokedEvent();

        if ($invokedEvent && !$invokedEvent->isStopped()) {
            $this->_workflow->getInvokedEvent()->stop();
        }
    }


    /**
     * Returns parameters reflection info
     * @return array
     */
    public static function getParamsReflection()
    {
        return array();
    }
}
