<?php

namespace Velis\Bpm\Workflow;

use Velis\Model\Cacheable;
use Velis\Model\DataObject;
use Velis\ParameterBag;

/**
 * Workflow triggered action type
 * @author Olek Procki <olo@velis.pl>
 */
class ActionType extends DataObject implements Cacheable
{
    /**
     * Sort mode
     * @var string
     */
    protected static $_sortMode = self::SORT_STRING;


    /**
     * Returns related table name
     * @return string
     */
    protected function _getTableName()
    {
        return 'app.workflow_action_type_tab';
    }


    /**
     * Returns list datasource
     * @return string
     */
    protected function _getListDatasource()
    {
        return 'app.workflow_action_type_tab wat';
    }


    /**
     * Returns event name
     * @return string
     */
    public function getName()
    {
        return $this->getTranslatedName();
    }


    /**
     * Returns handler class
     * @return string
     */
    public function getHandlerClass()
    {
        $namespaces = [
            '\Workflow\Handler\\',
            '\Velis\Bpm\Workflow\Handler\\'
        ];

        foreach ($namespaces as $namespace) {
            $class  = $namespace . $this->id();
            if (class_exists($class)) {
                return $class;
            }
        }
    }


    /**
     * Returns handler class parameters reflection
     * @return array
     */
    public function getHandlerReflection()
    {
        if ($class = $this->getHandlerClass()) {
            return $class::getParamsReflection();
        }
    }


    /**
     * {@inheritDoc}
     */
    public static function getList($page = 1, $params = null, $order = null, $limit = self::ITEMS_PER_PAGE, $fields = null): array
    {
        $params = new ParameterBag($params);

        if ($params['workflow_event_id']) {
            self::$_listDatasource = 'app.workflow_event_action_type';
        }

        $result = parent::getList($page, $params, $order, $limit, $fields);
        self::$_listDatasource = null;

        return $result;
    }
}
