<?php

namespace Velis\Bpm\Ticket\Service;

use Velis\Bpm\Ticket\Ticket;
use Velis\Bpm\Ticket\Log;

/**
 * Ticket service action context object interface
 * @author Olek Procki <olo@velis.pl>
 */
interface ContextInterface
{
    /**
     * Before action execution handler
     *
     * @param Ticket $ticket
     */
    public function preAction(Ticket $ticket);

    /**
     * After action execution handler
     *
     * @param Ticket $ticket
     * @param Log $log
     * @param array $connectedLogs
     * @param array $changes
     */
    public function postAction(Ticket $ticket, Log $log, array &$connectedLogs, array &$changes);


    /**
     * Before action nofification handler
     *
     * @param Ticket $ticket
     * @param Log $log
     */
    public function preNotify(Ticket $ticket, Log $log);
}
