<?php

namespace Velis\Bpm\Ticket\Service;

use Velis\Bpm\Ticket\Post;
use Velis\Bpm\Ticket\Log;
use Velis\Bpm\Ticket\Ticket;

/**
 * Service action result
 */
class ActionResult
{
    /**
     * Ticket instance related with action
     * @var Ticket
     */
    public $ticket;

    /**
     * Ticket log related with action
     * @var type
     */
    public $log;

    /**
     * Non interrupting errors registered during action execution
     * @var array
     */
    public $errors;


    /**
     * Constructor
     *
     * @param Ticket $ticket
     * @param Log $log
     * @param array $errors
     */
    public function __construct(Ticket $ticket, Log $log = null, array $errors = [])
    {
        $this->ticket = $ticket;
        $this->log    = $log;
        $this->errors = $errors;
    }

    /**
     * Returns true if any errors appeared during action
     * @return bool
     */
    public function didHaveErrors()
    {
        return count($this->errors) > 0;
    }

    public function getTicket(): Ticket
    {
        return $this->ticket;
    }

    public function getPost(): ?Post
    {
        return $this->log->getPost();
    }

    public function getErrors(): array
    {
        return $this->errors;
    }
}
