<?php

namespace Velis\Bpm\Ticket;

use Velis\Lang;
use Velis\Model\Cacheable;
use Velis\Model\DataObject;
use Velis\Model\Hierarchical;
use Velis\Model\Sanitizable;

/**
 * Ticket priority model
 *
 * @author Olek Procki <olo@velis.pl>
 * @author Michał Nosek <michal.nosek@velis.pl>
 */
class Priority extends DataObject implements Cacheable, Sanitizable
{
    const LEVEL_CRITICAL = 'Critical';
    const LEVEL_HIGH = 'High';
    const LEVEL_NORMAL = 'Normal';


    /**
     * Buffer for not cached model type (must be redeclared in Cachable class)
     * @var Hierarchical[]
     */
    protected static $_source;


    /**
     * Default list order
     * @var string
     */
    protected static $_listDefaultOrder = 'sort_order ASC NULLS FIRST, ticket_priority_id ASC';


    /**
     * {@inheritDoc}
     */
    protected function _getTableName()
    {
        return 'app.ticket_priority_tab';
    }


    /**
     * Returns priority name
     * @return string
     */
    public function getName()
    {
        return $this->getTranslatedName();
    }


    /**
     * Removes priority
     * @return bool
     */
    public function remove()
    {
        return parent::_remove();
    }


    /**
     * Return priority level
     * @return string
     */
    public function getPriorityLevel()
    {
        if ($this['priority_level']) {
            return $this->priority_level;
        }

        return $this->id();
    }
}
