<?php

namespace Velis\Bpm\Ticket\Mixin;

/**
 * Ticket visits functionality
 * @author Olek Procki <olo@velis.pl>
 */
trait VisitTrait
{
    /**
     * @var string
     */
    protected static $_visitClass = '\Velis\Bpm\Ticket\Visit';


    /**
     * Ticket visits
     * @var \Velis\Bpm\Ticket\Visit[]
     */
    protected $_visits;


    /**
     * Returns ticket visits
     * @return \Velis\Bpm\Ticket\Visit[]
     */
    public function getVisits($params = array(), $reload = false, bool $force = false)
    {
        $visitClass = static::$_visitClass;

        $params = $params ? array_merge($params, $this->_getPrimaryKeyParam()) : $this->_getPrimaryKeyParam();
        if ($force) {
            $params['force'] = true;
        }

        if (!isset($this->_visits) || $reload) {
            $this->_visits = $visitClass::listAll(
                $params
            );
        }
        foreach ($this->_visits as $visit) {
            $visit->setTicket($this);
        }
        return $this->_visits;
    }
}
