<?php

namespace Velis\Bpm\Ticket\Mixin;

use Company\Company;

/**
 * Companies functionality
 * @author Olek Procki <olo@velis.pl>
 */
trait CompanyTrait
{
    /**
     * Company list of ticket
     * @var \Company\Company
     */
    protected $_companyList;


    /**
     * Ticket company
     * @var \Company\Company
     */
    protected $_company;



    /**
     * Return true if client is assigned to ticket
     *
     * @param Company|int $company
     * @return bool
     */
    public function hasCompany($company)
    {
        if (!$company instanceof Company) {
            $company = new Company($company);
        }
        return $this->company_id == $company->id() || $this->getProject()->hasCompany($company);
    }


    /**
     * Returns Company id
     * @return int
     */
    public function getCompanyId()
    {
        return $this->company_id;
    }


    /**
     * Returns ticket company
     * @return \Velis\Bpm\Company
     */
    public function getCompany()
    {
        if (!isset($this->_company)) {
            if (array_key_exists($this->getCompanyId(), $this->getCompanyList())) {
                $this->_company = $this->_companyList[$this->getCompanyId()];
            } else {
                $this->_company = Company::bufferedInstance($this->getCompanyId());
            }
        }
        return $this->_company;
    }


    /**
     * Method placeholder
     * @return array
     */
    public function getCompanyList()
    {
        if (!isset($this->_companyList)) {
            $this->_loadCompanyList();
        }
        return $this->_companyList;
    }


    /**
     * Loads company list
     * @return \Velis\Bpm\Ticket\Ticket
     */
    protected function _loadCompanyList()
    {
        $this->_companyList = array();
        return $this;
    }
}
