<?php

namespace Velis\Bpm\Ticket\Command;

use Velis\App;
use Velis\Bpm\Ticket\Service\ContextInterface;
use Velis\Bpm\Ticket\Ticket;
use Velis\Bpm\Ticket\Log;

/**
 * Abstract handler of ticket service commands
 * @author Olek Procki <olo@velis.pl>
 */
abstract class AbstractHandler implements ContextInterface
{
    /**
     * Ticket service instance
     * @var \Velis\Bpm\Ticket\Service
     */
    protected $_service;


    /**
     * Constructor
     */
    public function __construct()
    {
        $this->_service = App::$di->get('ticketService');
    }


    /**
     * Before action execution handler
     *
     * @param Ticket $ticket
     */
    public function preAction(Ticket $ticket)
    {
        // to be overriden, implemented here in order to make this method optional
    }


    /**
     * After action execution handler
     *
     * @param Ticket $ticket
     * @param Log $log
     * @param array $connectedLogs
     * @param array $changes
     */
    public function postAction(Ticket $ticket, Log $log, array &$connectedLogs, array &$changes)
    {
        // to be overriden, implemented here in order to make this method optional
    }


    /**
     * Before action nofification handler
     *
     * @param Ticket $ticket
     * @param Log $log
     */
    public function preNotify(Ticket $ticket, Log $log)
    {
        // to be overriden, implemented here in order to make this method optional
    }


    /**
     * Command handle method
     */
    abstract public function handle($command);
}
