<?php

namespace Velis\Bpm\Ticket;

use Velis\Model\BaseModel;
use Velis\Filter;

/**
 * Ticket action prototype
 * @author Olek Procki <olo@velis.pl>
 */
abstract class Action extends BaseModel
{

    /**
     * Ticket instance
     * @var \Velis\Bpm\Ticket\Ticket
     */
    protected $_ticket;


    /**
     * Action parameters
     * @var \Velis\Filter
     */
    protected $_params;



    /**
     * Constructor
     *
     * @param \Velis\Bpm\Ticket\Ticket $ticket
     * @param array|ArrayObject $params
     */
    public function __construct($ticket, $params = null)
    {
        $this->_ticket  = $ticket;

        if (!$params instanceof Filter) {
            $this->_params = new Filter($params, true);
        } else {
            $this->_params = $params;
        }
        parent::__construct();
    }


    /**
     * Perform the action
     */
    abstract public function perform();
}
