<?php

namespace Velis\Bpm\Email;

use Velis\Lang;

/**
 * Email message notification model
 * @author Olek Procki <olo@velis.pl>
 */
class Notification extends \Velis\Notification
{

    const EMAIL_DELIVERY_REPORT     = 'email-delivery-report';
    const EMAIL_REJECTED            = 'email-rejected';

    /**
     * Notification type
     * @var string (one of TYPE_* consts)
     */
    protected $_type;


    /**
     * Constructor
     *
     * @param string $type
     * @param \Velis\Bpm\Email\Account|int
     */
    public function __construct($type, $emailAccount = null)
    {
        $this->_type = $type;
        parent::__construct();

        if ($emailAccount != null) {
            $this->setAccount($emailAccount);
        }
    }



    /**
     * Returns subject for notification email
     * @return string
     */
    protected function _getMailSubject()
    {
        switch ($this->_type) {
            case self::EMAIL_DELIVERY_REPORT:
                return Lang::get('EMAIL_DELIVERY_NOTIFICATION_TITLE');

            case self::EMAIL_REJECTED:
                return Lang::get('EMAIL_REJECTED_NOTIFICATION_TITLE');
        }
    }
}
