<?php

namespace Velis\Bpm\Email;

use Velis\Notification\Recipient;

/**
 * Email alias model
 *
 * @author Bartosz Izdebski <bartosz.izdebski@velis.pl>
 */
class Alias implements Recipient
{
    /**
     * email to return
     * @var string
     */
    protected $_emailAddress;

    public ?string $lang_id = null;

    /**
     * Constructor
     */
    public function __construct($emailAddress)
    {
        $this->_emailAddress = $emailAddress;
    }

    /**
     * zmiana obiektu na string
     */
    public function __toString()
    {
        return $this->_emailAddress;
    }

    /**
     * Returns email
     * @return string
     */
    public function getEmail()
    {
        return $this->_emailAddress;
    }
}
