<?php

namespace Velis\Bpm\Country;

use Velis\Arrays;
use Velis\Model\Cacheable;
use Velis\Model\DataObject;

/**
 * Units model
 * @author Damian Kurek <damian.kurek@velis.pl>
 */
class Units extends DataObject implements Cacheable
{
    /**
     * Returns table name
     */
    protected function _getTableName()
    {
        return 'app.country_unit_tab';
    }


    /**
     * Return primary key fields
     * @return array
     */
    protected function _getPrimaryKeyField()
    {
        return ['country_id', 'unit_type'];
    }

    /**
     * Return unit name
     * @return string
     */
    public function getName()
    {
        return $this['value'];
    }


    /**
     * Returns units by country id
     * @param string $countryId
     * @param int $stripTags
     * @return array
     */
    public static function getByCountry($countryId = 'PL', $stripTags = false)
    {
        if (!$result = Arrays::byValue(self::listCached(), 'country_id', $countryId)) {
            $result = Arrays::byValue(self::listCached(), 'country_id', 'PL');
        }

        if ($stripTags) {
            $result = array_map(function ($unit) {
                $unit['value'] = strip_tags($unit['value']);
                return $unit;
            }, $result);
        }

        return array_combine(Arrays::getColumn($result, 'unit_type'), $result);
    }
}
