<?php

namespace Velis\Bpm\Company;

use Velis\Model\DataObject;
use Velis\Model\Cacheable;
use Velis\Acl\Role;

/**
 * Company type dictionary entry model
 * @author Olek Procki <olo@velis.pl>
 */
class Type extends DataObject implements Cacheable
{

    /**
     * Returns dictionary table name
     * @return string
     */
    protected function _getTableName()
    {
        return 'app.company_type_tab';
    }


    /**
     * Returns valid name for current language
     * @return string
     */
    public function getName()
    {
        return $this->getTranslatedName();
    }


    /**
     * Returns related ACL role
     * @return \Velis\Acl\Role
     */
    public function getRole()
    {
        return Role::get($this->role_id);
    }
}
