<?php

namespace Velis;

use Velis\Exception as VelisException;

/**
 * Encryption & Authentication package
 * @author Olek Procki <olo@velis.pl>
 */
class Auth
{
    /**
     * Sanitizes input credentials. Returns null if empty.
     *
     * @param mixed $input
     *
     * @return string|null
     * @throws VelisException
     */
    public static function sanitizeInput($input)
    {
        if (!is_string($input) && $input !== false) {
            VelisException::raise('Invalid credential value passed');
        }

        return trim($input) ?: null;
    }
}
