<?php

namespace Velis\Atom;

/**
 * Atom IDE helper class
 * @author Paweł Robaczewski <pr@velis.pl>
 */
class Classmap
{
    public $classes = array();

    public function __construct()
    {
        define('ROOT_PATH', dirname(dirname(dirname(__DIR__))) . DIRECTORY_SEPARATOR);
        define('MODULE_PATH', ROOT_PATH . 'module' . DIRECTORY_SEPARATOR);

        $modules = array_slice(scandir(MODULE_PATH), 2);
        foreach ($modules as $module) {
            self::$classes = array_merge(self::$classes, $this->extractClasses('\\' . $module, MODULE_PATH . $module . '/src'));
        }

        self::$classes = array_merge(self::$classes, $this->extractClasses('\Velis', ROOT_PATH . 'lib/Velis'));
    }

    public function extractClasses($namespace, $path)
    {
        $classes = array();

        $entries = array_slice(scandir($path), 2);
        foreach ($entries as $entry) {
            if (is_dir($path . DIRECTORY_SEPARATOR . $entry)) {
                $classes = array_merge($classes, $this->extractClasses($namespace . '\\' . $entry, $path . DIRECTORY_SEPARATOR . $entry));
            } elseif (substr($entry, -4) == '.php') {
                $classes[$namespace . '\\' . substr($entry, 0, -4)] = $path;
            }
        }

        return $classes;
    }
}

$classMap = new Classmap();
return $classMap->classes;
