<?php

namespace Velis\Atom;

use Velis\App\LoaderFactory;

/**
 * Atom IDE helper class
 * @author Paweł Robaczewski <pr@velis.pl>
 * @deprecated use composer autoloader instead
 */
class Autoloader
{
    public function __construct()
    {
        define('ROOT_PATH', dirname(dirname(dirname(__DIR__))) . DIRECTORY_SEPARATOR);
        define('MODULE_PATH', ROOT_PATH . 'module' . DIRECTORY_SEPARATOR);

        $loaderFactory = new LoaderFactory();
        $loader = $loaderFactory->createLoader();

        $namespaces = [];
        $modules = array_slice(scandir(MODULE_PATH), 2);
        foreach ($modules as $module) {
            $namespaces[$module] = MODULE_PATH . $module . '/src';
        }

        $loader
            ->setDirectories([
                ROOT_PATH . 'lib/Velis',
                ROOT_PATH . 'lib',
                ROOT_PATH . 'module',
            ])
            ->setNamespaces($namespaces)
            ->register()
        ;
    }
}

new Autoloader();
