<?php

namespace Velis\App;

use InvalidArgumentException;

class Loader
{
    /**
     * @var \Phalcon\Loader|\Phalcon\Autoload\Loader
     */
    private $wrapped;

    private int $version;

    /**
     * @param \Phalcon\Loader|\Phalcon\Autoload\Loader $wrapped
     */
    public function __construct($wrapped, int $version)
    {
        if (!in_array($version, [PhalconVersion::PHALCON4, PhalconVersion::PHALCON5])) {
            throw new InvalidArgumentException(sprintf('Invalid value passed as version argument: %s', $version));
        }

        $this->wrapped = $wrapped;
        $this->version = $version;
    }

    /**
     * @param array $directories
     * @return $this
     */
    public function setDirectories(array $directories): self
    {
        switch ($this->version) {
            case PhalconVersion::PHALCON5:
                $this->wrapped->setDirectories($directories);
                break;
            case PhalconVersion::PHALCON4:
                $this->wrapped->registerDirs($directories);
                break;
        }

        return $this;
    }

    /**
     * @param array $namespaces
     * @return $this
     */
    public function setNamespaces(array $namespaces): self
    {
        switch ($this->version) {
            case PhalconVersion::PHALCON5:
                $this->wrapped->setNamespaces($namespaces);
                break;
            case PhalconVersion::PHALCON4:
                $this->wrapped->registerNamespaces($namespaces);
                break;
        }

        return $this;
    }

    /**
     * @param array $classes
     * @return $this
     */
    public function setClasses(array $classes): self
    {
        switch ($this->version) {
            case PhalconVersion::PHALCON5:
                $this->wrapped->setClasses($classes);
                break;
            case PhalconVersion::PHALCON4:
                $this->wrapped->registerClasses($classes);
                break;
        }

        return $this;
    }

    /**
     * @return $this
     */
    public function register(): self
    {
        $this->wrapped->register();

        return $this;
    }
}
