<?php

namespace Velis\Api\HttpExceptionHandler\Map;

/**
 * Here we can define our exception map. Order is important - first matched exception will be used.
 * We can match exception in two ways:
 * - as exact hit (when our caught exception class is the same as the one in the map)
 * - as instance (when our caught exception is an instance of the one in the map)
 * In the Map we can set all the values we want to use in the response and define onCatch and formatter closures
 * used to successively:
 * - add action on catch (eg. report exception to somewhere else)
 * - and format the response (eg. modify error message depending on details):
 *
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
interface MapInterface
{
    /**
     * Actually it's a generator, but PHP Storm at this moment does not understand `Generator<int, MapItem>` syntax,
     * so it's a workaround.
     * @return iterable<int, MapItem>
     */
    public function load(): iterable;
}
