<?php

namespace Velis\Acl;

use Velis\App;
use Velis\Arrays;
use Velis\Session\RedisSession;
use Velis\Session\SessionFactoryInterface;

trait RedisSessionTrait
{
    private function getSession(): RedisSession
    {
        if (App::isConsole()) {
            $config = Arrays::toArray(App::$config->session);

            if (!$config['prefix']) {
                $config['prefix'] = md5(App::$config->db->database ?: APP_PATH);
            }

            if (!$config['lifetime']) {
                $config['lifetime'] = ini_get('session.gc_maxlifetime');
            }

            /** @var SessionFactoryInterface $sessionFactory */
            $sessionFactory = App::$di['sessionFactory'];
            return $sessionFactory->createRedisSession($config);
        }

        return App::$session;
    }
}
