<?php

namespace Sabre\VObject;

use PHPUnit\Framework\TestCase;

class Issue467Test extends TestCase
{
    public function testRead(): void
    {
        $data = 'BEGIN:VCALENDAR
VERSION:2.0
PRODID:-//Sabre//Sabre VObject 4.3.5//EN
CALSCALE:GREGORIAN
BEGIN:VTIMEZONE
TZID:Customized Time Zone
BEGIN:STANDARD
DTSTART:16010101T030000
TZOFFSETFROM:+0200
TZOFFSETTO:+0100
RRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=10
END:STANDARD
BEGIN:DAYLIGHT
DTSTART:16010101T020000
TZOFFSETFROM:+0100
TZOFFSETTO:+0200
RRULE:FREQ=YEARLY;INTERVAL=1;BYDAY=-1SU;BYMONTH=3
END:DAYLIGHT
END:VTIMEZONE
BEGIN:VEVENT
DESCRIPTION;LANGUAGE=de-DE:\n
UID:040000008200E00074C5B7101A82E00800000000617EC2A24F5ED901000000000000000
 0100000005F326A277A3E8A4D8E8CA31C1AF73F5F
SUMMARY;LANGUAGE=de-DE:Test
DTSTART;TZID=Customized Time Zone:20230328T140000
DTEND;TZID=Customized Time Zone:20230328T163000
PRIORITY:5
DTSTAMP:20230327T074734Z
TRANSP:OPAQUE
STATUS:CONFIRMED
SEQUENCE:1
LOCATION:Test location
LAST-MODIFIED:20230329T082329Z
CLASS:PRIVATE
BEGIN:VALARM
DESCRIPTION:REMINDER
TRIGGER;RELATED=START:P
ACTION:DISPLAY
END:VALARM
END:VEVENT
END:VCALENDAR';

        $oVCal = Reader::read($data);
        self::assertEquals(new \DateInterval('PT0S'), $oVCal->VEVENT->VALARM->TRIGGER->getDateInterval());
    }
}
